﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using hive;


public class Notification : MonoBehaviour {

	public Toast toast;

	public Sprite switchOn;
	public Sprite switchOff;

	public GameObject objALL;
	public GameObject line1;

	public Button buttonALL;
	public Button buttonGAME;
	public Button buttonNOTICE;
	public Button buttonNIGHTTIME;

	private bool _isAll = true;
	private bool _isGame = true;
	private bool _isNotice = true;
	private bool _isNightTime = false;


	public bool isAll {
		set {
			_isAll = value;

			_isGame = value;
			isNotice = value;
		}
		get {
			return _isAll;
		}
	}

	public bool isGame {
		set {
			_isGame = value;
			if ( !(_isGame ^ _isNotice) )
				_isAll = value;
		}
		get {
			return _isGame;
		}
	}

	public bool isNotice {
		set {
			_isNotice = value;

			if (!_isNotice)
				_isNightTime = false;
			
			if ( !(_isGame ^ _isNotice) )
				_isAll = value;
		}
		get {
			return _isNotice;
		}
	}

	public bool isNightTime {
		set {
			_isNightTime = value;
			if (_isNightTime)
				isNotice = true;
		}
		get {
			return _isNightTime;
		}
	}
		

	// Use this for initialization
	void Start () {

		#if UNITY_ANDROID
		objALL.SetActive(true);
		line1.SetActive(true);
		#elif UNITY_IOS
		objALL.SetActive(false);
		line1.SetActive(false);
		#endif 

		#if UNITY_EDITOR
		onHIVEManagerRemotePush(true, "Success", new RemotePush(isNotice, isNightTime));
		#else
		HIVEManager.shared.requestPushPermission();
		HIVEManager.shared.getRemotePush(onHIVEManagerRemotePush);
		#endif
	}


	public void onExitClick() {

		this.gameObject.SetActive (false);
	}


	public void onALLClick() {
		isAll = !isAll;

		if (isAll) {
			toast.show ("[Com2uS Platform]\nAgreed to get notification at " + getToday());
		} else {
			toast.show ("[Com2uS Platform]\nDisagreed to get notification at " + getToday());
		}

		#if UNITY_EDITOR
		onHIVEManagerRemotePush(true, "Success", new RemotePush(isNotice, isNightTime));
		#else
		HIVEManager.shared.setRemotePush(new RemotePush(isNotice, isNightTime), onHIVEManagerRemotePush);
		#endif
	}


	public void onGAMEClick() {
		isGame = !isGame;

		setButton ();
	}


	public void onNOTICEClick() {
		isNotice = !isNotice;

		if (isNotice) {
			toast.show ("[Com2uS Platform]\nAgreed to get notice notification at " + getToday());
		} else {
			toast.show ("[Com2uS Platform]\nDisagreed to get notice notification at " + getToday());
			isNightTime = false;
		}

		#if UNITY_EDITOR
		onHIVEManagerRemotePush(true, "Success", new RemotePush(isNotice, isNightTime));
		#else
		HIVEManager.shared.setRemotePush(new RemotePush(isNotice, isNightTime), onHIVEManagerRemotePush);
		#endif
	}


	public void onNITHGTIMEClick() {
		isNightTime = !isNightTime;

		if (isNightTime) {
			toast.show ("[Com2uS Platform]\nAgreed to get night notification at " + getToday());
		} else {
			toast.show ("[Com2uS Platform]\nDisagreed to get night notification at " + getToday());
		}

		#if UNITY_EDITOR
		onHIVEManagerRemotePush(true, "Success", new RemotePush(isNotice, isNightTime));
		#else
		HIVEManager.shared.setRemotePush(new RemotePush(isNotice, isNightTime), onHIVEManagerRemotePush);
		#endif
	}


	void onHIVEManagerRemotePush(bool isSuccess, string message, RemotePush remotePush)
	{
		if (isSuccess) {
			isNotice = remotePush.isAgreeNotice;
			isNightTime = remotePush.isAgreeNight;
		}
			
		setButton ();
	}


	void setButton()
	{
		buttonALL.GetComponent<Image>().sprite = isAll ? switchOn : switchOff;
		buttonGAME.GetComponent<Image>().sprite = isGame ? switchOn : switchOff;
		if (isNotice) {
			buttonNOTICE.GetComponent<Image>().sprite = switchOn;
			buttonNIGHTTIME.GetComponent<Image>().sprite = isNightTime ? switchOn : switchOff;
			buttonNIGHTTIME.interactable = true;
		} else {
			buttonNOTICE.GetComponent<Image>().sprite = switchOff;
			buttonNIGHTTIME.GetComponent<Image>().sprite = switchOff;
			buttonNIGHTTIME.interactable = false;
		}
	}


	string getToday()
	{
		return System.DateTime.Now.ToString ("yyyy.MM.dd");
	}

}
